"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateTransformSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_documentation_links = require("../../hooks/use_documentation_links");
var _use_search_items = require("../../hooks/use_search_items");
var _navigation = require("../../services/navigation");
var _capabilities_wrapper = require("../../components/capabilities_wrapper");
var _wizard = require("./components/wizard");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateTransformSection = ({
  match
}) => {
  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    _navigation.breadcrumbService.setBreadcrumbs(_navigation.BREADCRUMB_SECTION.CREATE_TRANSFORM);
    _navigation.docTitleService.setTitle('createTransform');
  }, []);
  const {
    esTransform
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const {
    error: searchItemsError,
    searchItems
  } = (0, _use_search_items.useSearchItems)(match.params.savedObjectId);
  const docsLink = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: esTransform,
    target: "_blank",
    iconType: "question",
    "data-test-subj": "documentationLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.transformsWizard.transformDocsLinkText",
    defaultMessage: "Transform docs"
  }));
  return /*#__PURE__*/_react.default.createElement(_capabilities_wrapper.CapabilitiesWrapper, {
    requiredCapabilities: ['canGetTransform', 'canPreviewTransform', 'canCreateTransform', 'canStartStopTransform']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformsWizard.createTransformTitle",
      defaultMessage: "Create transform"
    }),
    rightSideItems: [docsLink],
    bottomBorder: true,
    paddingSize: 'none'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    "data-test-subj": "transformPageCreateTransform",
    paddingSize: 'none'
  }, searchItemsError !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: searchItemsError,
    color: "danger",
    iconType: "warning"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), searchItems !== undefined && /*#__PURE__*/_react.default.createElement(_wizard.Wizard, {
    searchItems: searchItems
  })));
};
exports.CreateTransformSection = CreateTransformSection;