"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptInMessage = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OptInMessage = ({
  addBasePath,
  telemetryService,
  telemetryConstants,
  onClick
}) => {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.dataManagementDisclaimerPrivacy",
    defaultMessage: "{optInStatus} This allows us to learn what our users are most interested in, so we can improve our products and services. Refer to our {privacyStatementLink}.",
    values: {
      optInStatus: /*#__PURE__*/React.createElement("strong", null, telemetryService.isOptedIn ? /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.enabledStatus",
        defaultMessage: "Usage collection is enabled."
      }) : /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.disabledStatus",
        defaultMessage: "Usage collection is disabled."
      })),
      privacyStatementLink:
      /*#__PURE__*/
      /* eslint-disable-next-line @elastic/eui/href-or-on-click */
      React.createElement(_eui.EuiLink, {
        onClick: onClick,
        href: telemetryConstants.getPrivacyStatementUrl(),
        target: "_blank",
        rel: "noopener"
      }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.dataManagementDisclaimerPrivacyLink",
        defaultMessage: "Privacy Statement"
      }))
    }
  }), ' ', renderTelemetryEnabledOrDisabledText(telemetryService, addBasePath, onClick));
};
exports.OptInMessage = OptInMessage;
function renderTelemetryEnabledOrDisabledText(telemetryService, addBasePath, onClick) {
  if (!telemetryService.userCanChangeSettings || !telemetryService.getCanChangeOptInStatus()) {
    return null;
  }
  const isOptedIn = telemetryService.getIsOptedIn();
  const actionMessage = isOptedIn ? /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.dataManagementDisableCollectionLink",
    defaultMessage: "Disable usage collection."
  }) : /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.dataManagementEnableCollectionLink",
    defaultMessage: "Enable usage collection."
  });
  return /*#__PURE__*/ /* eslint-disable-next-line @elastic/eui/href-or-on-click */React.createElement(_eui.EuiLink, {
    href: addBasePath(_constants.PATH_TO_ADVANCED_SETTINGS),
    onClick: onClick
  }, actionMessage);
}