"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptInExampleFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _loading_spinner = require("./loading_spinner");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * OptInExampleFlyout props
 */

/**
 * React component for displaying the example data associated with the Telemetry opt-in banner.
 */
class OptInExampleFlyout extends React.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      data: null,
      isLoading: true,
      hasPrivilegeToRead: false
    });
  }
  async componentDidMount() {
    this._isMounted = true;
    try {
      const {
        fetchExample
      } = this.props;
      const clusters = await fetchExample();
      if (this._isMounted) {
        this.setState({
          data: Array.isArray(clusters) ? clusters : null,
          isLoading: false,
          hasPrivilegeToRead: true
        });
      }
    } catch (err) {
      this.setState({
        isLoading: false,
        hasPrivilegeToRead: err.status !== 403
      });
    }
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  renderBody({
    data,
    isLoading,
    hasPrivilegeToRead
  }) {
    if (isLoading) {
      return _loading_spinner.loadingSpinner;
    }
    if (!hasPrivilegeToRead) {
      return /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
          id: "telemetry.callout.errorUnprivilegedUserTitle",
          defaultMessage: "Error displaying cluster statistics"
        }),
        color: "danger",
        iconType: "cross"
      }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.callout.errorUnprivilegedUserDescription",
        defaultMessage: "You do not have access to see unencrypted cluster statistics."
      }));
    }
    if (data === null) {
      return /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
          id: "telemetry.callout.errorLoadingClusterStatisticsTitle",
          defaultMessage: "Error loading cluster statistics"
        }),
        color: "danger",
        iconType: "cross"
      }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.callout.errorLoadingClusterStatisticsDescription",
        defaultMessage: "An unexpected error occurred while attempting to fetch the cluster statistics. This can occur because Elasticsearch failed, Kibana failed, or there is a network error. Check Kibana, then reload the page and try again."
      }));
    }
    return /*#__PURE__*/React.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true
    }, JSON.stringify(data, null, 2));
  }
  render() {
    const modalTitleId = (0, _eui.htmlIdGenerator)()('flyoutTitle');
    return /*#__PURE__*/React.createElement(_eui.EuiPortal, null, /*#__PURE__*/React.createElement(_eui.EuiFlyout, {
      "aria-labelledby": modalTitleId,
      ownFocus: true,
      onClose: this.props.onClose,
      maxWidth: true
    }, /*#__PURE__*/React.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/React.createElement(_eui.EuiTitle, null, /*#__PURE__*/React.createElement("h2", {
      id: modalTitleId
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "telemetry.callout.clusterStatisticsTitle",
      defaultMessage: "Cluster statistics"
    }))), /*#__PURE__*/React.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/React.createElement(_eui.EuiText, null, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "telemetry.callout.clusterStatisticsDescription",
      defaultMessage: "This is an example of the basic cluster statistics that we'll collect. It includes the number of indices, shards, and nodes. It also includes high-level usage statistics, such as whether monitoring is turned on."
    })))), /*#__PURE__*/React.createElement(_eui.EuiFlyoutBody, null, this.renderBody(this.state))));
  }
}
exports.OptInExampleFlyout = OptInExampleFlyout;