"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockRun = mockRun;
exports.mockTask = mockTask;
var _uuid = require("uuid");
var _result_type = require("../lib/result_type");
var _test_utils = require("../test_utils");
var _task_running = require("../task_running");
var _task = require("../task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mockRun() {
  return jest.fn(async () => {
    await (0, _test_utils.sleep)(0);
    return (0, _result_type.asOk)({
      state: {}
    });
  });
}
function mockTask(overrides = {}, definitionOverrides = {}) {
  return {
    isExpired: false,
    taskExecutionId: (0, _uuid.v4)(),
    id: (0, _uuid.v4)(),
    cancel: async () => undefined,
    markTaskAsRunning: jest.fn(async () => true),
    run: mockRun(),
    stage: _task_running.TaskRunningStage.PENDING,
    toString: () => `TaskType "shooooo"`,
    isAdHocTaskAndOutOfAttempts: false,
    removeTask: jest.fn(),
    get expiration() {
      return new Date();
    },
    get startedAt() {
      return new Date();
    },
    get definition() {
      return {
        type: '',
        title: '',
        timeout: '5m',
        cost: _task.TaskCost.Normal,
        createTaskRunner: jest.fn(),
        ...definitionOverrides
      };
    },
    isSameTask() {
      return false;
    },
    ...overrides
  };
}