"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorConfiguration = MonitorConfiguration;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _monitor_filters_form = require("./monitor_filters_form");
var _state = require("../../synthetics/state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorConfigurationContext = /*#__PURE__*/_react.default.createContext({
  overviewView: _state.DEFAULT_OVERVIEW_VIEW,
  onChangeCompactViewSwitch: () => {}
});
const COMPACT_VIEW_LABEL = _i18n.i18n.translate('xpack.synthetics.embeddables.monitorsOverview.compactViewLabel', {
  defaultMessage: 'Compact view'
});
function MonitorConfiguration({
  initialInput,
  onCreate,
  onCancel,
  title,
  children
}) {
  const [overviewView, setOverviewView] = (0, _react.useState)((initialInput === null || initialInput === void 0 ? void 0 : initialInput.view) || _state.DEFAULT_OVERVIEW_VIEW);
  const onChangeCompactViewSwitch = e => {
    setOverviewView(e.target.checked ? 'compactView' : 'cardView');
  };
  const methods = (0, _reactHookForm.useForm)({
    defaultValues: {
      monitorIds: [],
      projects: [],
      tags: [],
      monitorTypes: [],
      locations: []
    },
    values: initialInput === null || initialInput === void 0 ? void 0 : initialInput.filters,
    mode: 'all'
  });
  const {
    getValues,
    formState
  } = methods;
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'monitorConfigurationFlyout'
  });
  const onConfirmClick = () => {
    const newFilters = getValues();
    onCreate({
      filters: newFilters,
      view: overviewView
    });
  };
  const hasViewChanged = (initialInput === null || initialInput === void 0 ? void 0 : initialInput.view) && overviewView !== initialInput.view;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCancel,
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, methods, /*#__PURE__*/_react.default.createElement(_monitor_filters_form.MonitorFiltersForm, null))), /*#__PURE__*/_react.default.createElement(MonitorConfigurationContext.Provider, {
    value: {
      overviewView,
      onChangeCompactViewSwitch
    }
  }, children))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsMonitorConfigurationCancelButton",
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.embeddable.config.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsMonitorConfigurationSaveButton",
    isDisabled: !(formState.isDirty || !initialInput || hasViewChanged),
    onClick: onConfirmClick,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.overviewEmbeddableSynthetics.config.confirmButtonLabel",
    defaultMessage: "Save"
  })))));
}
function ViewSwitch() {
  const {
    onChangeCompactViewSwitch,
    overviewView
  } = _react.default.useContext(MonitorConfigurationContext);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    checked: overviewView === 'compactView',
    label: COMPACT_VIEW_LABEL,
    onChange: onChangeCompactViewSwitch
  });
}
MonitorConfiguration.ViewSwitch = ViewSwitch;