"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.previewSignificantEvents = previewSignificantEvents;
var _streamsSchema = require("@kbn/streams-schema");
var _boom = require("@hapi/boom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createSearchRequest({
  from,
  to,
  query,
  bucketSize
}) {
  return {
    size: 0,
    query: {
      bool: {
        filter: [{
          range: {
            '@timestamp': {
              gte: from.toISOString(),
              lte: to.toISOString()
            }
          }
        }, {
          kql: {
            query: query.kql.query
          }
          // TODO: kql is not in the ES client's types yet (06-2025)
        }]
      }
    },
    aggs: {
      occurrences: {
        date_histogram: {
          field: '@timestamp',
          fixed_interval: bucketSize,
          extended_bounds: {
            min: from.toISOString(),
            max: to.toISOString()
          }
        }
      },
      change_points: {
        change_point: {
          buckets_path: 'occurrences>_count'
        }
        // TODO: change_points is not in the ES client's types yet (06-2025)
      }
    }
  };
}
async function previewSignificantEvents(params, dependencies) {
  var _aggregations$occurre;
  const {
    bucketSize,
    from,
    to,
    definition,
    query
  } = params;
  const {
    scopedClusterClient
  } = dependencies;
  const searchRequest = createSearchRequest({
    bucketSize,
    from,
    query,
    to
  });
  const response = await scopedClusterClient.asCurrentUser.search({
    index: (0, _streamsSchema.getIndexPatternsForStream)(definition),
    track_total_hits: false,
    ...searchRequest
  });
  if (!response.aggregations) {
    throw (0, _boom.notFound)();
  }
  const aggregations = response.aggregations;
  return {
    ...query,
    change_points: aggregations.change_points,
    occurrences: (_aggregations$occurre = aggregations.occurrences.buckets.map(bucket => {
      return {
        date: bucket.key_as_string,
        count: bucket.doc_count
      };
    })) !== null && _aggregations$occurre !== void 0 ? _aggregations$occurre : []
  };
}