"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamsAppPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/dataset-quality-plugin/public");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireDefault(require("react"));
var _discover_streams_link = require("./discover_streams_link");
var _app_locator = require("./app_locator");
var _service = require("./telemetry/service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StreamsApplication = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./application'))).then(mod => ({
  default: mod.StreamsApplication
})));
class StreamsAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "telemetry", new _service.StreamsTelemetryService());
    this.context = context;
    this.logger = context.logger.get();
  }
  setup(coreSetup) {
    this.telemetry.setup(coreSetup.analytics);
    return {};
  }
  start(coreStart, pluginsStart) {
    const locator = new _app_locator.StreamsAppLocatorDefinition();
    pluginsStart.share.url.locators.create(locator);
    pluginsStart.streams.status$.subscribe(status => {
      if (status.status !== 'enabled') return;
      pluginsStart.discoverShared.features.registry.register({
        id: 'streams',
        renderStreamsField: (0, _discover_streams_link.createDiscoverStreamsLink)({
          streamsRepositoryClient: pluginsStart.streams.streamsRepositoryClient,
          locator: pluginsStart.share.url.locators.get(locator.id),
          coreApplication: coreStart.application
        })
      });
    });
    return {
      createStreamsApplicationComponent: () => {
        return ({
          appMountParameters,
          PageTemplate
        }) => {
          const services = {
            dataStreamsClient: new _public.DataStreamsStatsService().start({
              http: coreStart.http
            }).getClient(),
            PageTemplate,
            telemetryClient: this.telemetry.getClient()
          };

          // Trigger fetch to ensure the time filter has an up-to-date time range when the app mounts.
          // This is done to ensure that dynamic time ranges (like "Last 15 minutes") are applied like they
          // would be in discover or dashboards.
          pluginsStart.data.query.timefilter.timefilter.triggerFetch();
          return /*#__PURE__*/_react.default.createElement(StreamsApplication, {
            coreStart: coreStart,
            pluginsStart: pluginsStart,
            services: services,
            appMountParameters: appMountParameters,
            isServerless: this.context.env.packageInfo.buildFlavor === 'serverless'
          });
        };
      }
    };
  }
}
exports.StreamsAppPlugin = StreamsAppPlugin;