"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSignificantEvents = void 0;
var _calculateAuto = require("@kbn/calculate-auto");
var _moment = _interopRequireDefault(require("moment"));
var _use_kibana = require("./use_kibana");
var _use_streams_app_fetch = require("./use_streams_app_fetch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchSignificantEvents = ({
  name,
  start,
  end
}) => {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        },
        data
      }
    }
  } = (0, _use_kibana.useKibana)();
  const result = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    const isoFrom = new Date(start).toISOString();
    const isoTo = new Date(end).toISOString();
    const {
      min,
      max
    } = data.query.timefilter.timefilter.calculateBounds({
      from: isoFrom,
      to: isoTo
    });
    if (!min || !max) {
      return undefined;
    }
    const bucketSize = _calculateAuto.calculateAuto.near(50, _moment.default.duration(max.diff(min)));
    if (!bucketSize) {
      return undefined;
    }
    const intervalString = `${bucketSize.asSeconds()}s`;
    const response = await streamsRepositoryClient.fetch('GET /api/streams/{name}/significant_events 2023-10-31', {
      params: {
        path: {
          name
        },
        query: {
          from: isoFrom,
          to: isoTo,
          bucketSize: intervalString
        }
      },
      signal
    }).then(res => {
      return res.map(series => {
        const {
          occurrences,
          change_points: changePoints,
          ...query
        } = series;
        return {
          query,
          change_points: changePoints,
          occurrences: occurrences.map(occurrence => ({
            x: new Date(occurrence.date).getTime(),
            y: occurrence.count
          }))
        };
      });
    });
    return response;
  }, [name, start, end, streamsRepositoryClient, data.query.timefilter]);
  return result;
};
exports.useFetchSignificantEvents = useFetchSignificantEvents;