"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignificantEventFlyout = SignificantEventFlyout;
exports.SignificantEventFlyoutContents = SignificantEventFlyoutContents;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../../hooks/use_streams_app_fetch");
var _use_timefilter = require("../../../hooks/use_timefilter");
var _spark_plot = require("../../spark_plot");
var _uncontrolled_streams_app_bar = require("../../streams_app_search_bar/uncontrolled_streams_app_bar");
var _i18n2 = require("./i18n");
var _use_significant_event_preview_fetch = require("./use_significant_event_preview_fetch");
var _use_significant_event_validation = require("./use_significant_event_validation");
var _use_spark_plot_data_from_sig_events = require("./use_spark_plot_data_from_sig_events");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SignificantEventFlyoutContents({
  name,
  query,
  onClose,
  onCreate,
  onUpdate
}) {
  const [queryValues, setQueryValues] = (0, _react.useState)({
    id: (0, _uuid.v4)(),
    kql: {
      query: ''
    },
    ...query
  });
  const [touched, setTouched] = (0, _react.useState)({
    title: false,
    kql: false
  });
  const [loading, setLoading] = (0, _react.useState)(false);
  const {
    dependencies: {
      start: {
        data
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    timeState: {
      timeRange: initialTimeRange,
      start,
      end
    }
  } = (0, _use_timefilter.useTimefilter)();
  const [timeRange, setTimeRange] = (0, _react.useState)(initialTimeRange);
  const dataViewsFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(() => {
    return data.dataViews.create({
      title: name
    }).then(value => {
      return [value];
    });
  }, [data.dataViews, name]);
  const validation = (0, _use_significant_event_validation.useSignificantEventValidation)({
    queryValues
  });
  const validationMessages = (0, _react.useMemo)(() => {
    return {
      title: validation.title && touched.title ? {
        isInvalid: true,
        error: validation.title
      } : {},
      kql: validation.kql && touched.kql ? {
        isInvalid: true,
        error: validation.kql
      } : {}
    };
  }, [validation, touched]);
  const previewFetch = (0, _use_significant_event_preview_fetch.useSignificantEventPreviewFetch)({
    name,
    queryValues,
    timeRange
  });
  const xFormatter = (0, _react.useMemo)(() => {
    return (0, _charts.niceTimeFormatter)([start, end]);
  }, [start, end]);
  const sparkPlotData = (0, _use_spark_plot_data_from_sig_events.useSparkplotDataFromSigEvents)({
    previewFetch,
    queryValues,
    xFormatter
  });
  const parsedQuery = (0, _react.useMemo)(() => {
    return _streamsSchema.streamQuerySchema.safeParse(queryValues);
  }, [queryValues]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, (0, _i18n2.getSigEventFlyoutTitle)(query)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, validationMessages.title, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, _i18n.i18n.translate('xpack.streams.significantEventFlyout.formFieldTitleLabel', {
      defaultMessage: 'Title'
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: queryValues === null || queryValues === void 0 ? void 0 : queryValues.title,
    onChange: event => {
      const next = event.currentTarget.value;
      setQueryValues(prev => ({
        ...prev,
        title: next
      }));
      setTouched(prev => ({
        ...prev,
        title: true
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, _i18n.i18n.translate('xpack.streams.significantEventFlyout.formFieldQueryLabel', {
      defaultMessage: 'Query'
    }))
  }, validationMessages.kql), /*#__PURE__*/_react.default.createElement(_uncontrolled_streams_app_bar.UncontrolledStreamsAppSearchBar, {
    query: queryValues.kql ? {
      language: 'kuery',
      ...queryValues.kql
    } : {
      language: 'kuery',
      query: ''
    },
    showQueryInput: true,
    onQueryChange: () => {
      setTouched(prev => ({
        ...prev,
        kql: true
      }));
    },
    onQuerySubmit: next => {
      setQueryValues(prev => {
        var _next$query;
        return {
          ...prev,
          kql: {
            query: typeof ((_next$query = next.query) === null || _next$query === void 0 ? void 0 : _next$query.query) === 'string' ? next.query.query : ''
          }
        };
      });
      setTouched(prev => ({
        ...prev,
        kql: true
      }));
      if (next.dateRange) {
        setTimeRange(next.dateRange);
      }
    },
    dateRangeFrom: timeRange.from,
    dateRangeTo: timeRange.to,
    placeholder: _i18n.i18n.translate('xpack.streams.significantEventFlyout.queryPlaceholder', {
      defaultMessage: 'Filter events'
    }),
    indexPatterns: dataViewsFetch.value,
    submitOnBlur: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
    id: `query_preview_${query === null || query === void 0 ? void 0 : query.id}`,
    name: _i18n.i18n.translate('xpack.streams.significantEventFlyout.previewChartSeriesName', {
      defaultMessage: `Count`
    }),
    timeseries: sparkPlotData.timeseries,
    type: "bar",
    annotations: sparkPlotData.annotations,
    xFormatter: xFormatter
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    onClick: () => {
      onClose === null || onClose === void 0 ? void 0 : onClose();
    }
  }, _i18n.i18n.translate('xpack.streams.significantEventFlyout.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    iconType: query ? 'save' : 'plusInCircle',
    disabled: loading || !parsedQuery.success,
    isLoading: loading,
    onClick: () => {
      if (!parsedQuery.success) {
        return;
      }
      setLoading(true);
      if (query) {
        onUpdate === null || onUpdate === void 0 ? void 0 : onUpdate(parsedQuery.data).finally(() => {
          setLoading(false);
        });
      } else {
        onCreate === null || onCreate === void 0 ? void 0 : onCreate(parsedQuery.data).finally(() => {
          setLoading(false);
        });
      }
    }
  }, (0, _i18n2.getSigEventSubmitTitle)(query)))));
}
function SignificantEventFlyout(props) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => {
      var _props$onClose;
      (_props$onClose = props.onClose) === null || _props$onClose === void 0 ? void 0 : _props$onClose.call(props);
    },
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(SignificantEventFlyoutContents, props));
}