"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewMatches = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const matchText = _i18n.i18n.translate('xpack.streams.streamRouting.previewMatchesText', {
  defaultMessage: 'Approximate match rate'
});
const errorText = _i18n.i18n.translate('xpack.streams.streamRouting.previewMatchesErrorText', {
  defaultMessage: 'Error loading match rate'
});
const PreviewMatches = ({
  approximateMatchingPercentage,
  error,
  isLoading
}) => {
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "center"
    }, `${matchText}: `, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    }));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "center"
    }, `${matchText}: ${errorText}`);
  }
  if (approximateMatchingPercentage) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "center"
    }, `${matchText}: ${approximateMatchingPercentage}`, /*#__PURE__*/_react.default.createElement(InfoTooltip, null));
  }
  return null;
};
exports.PreviewMatches = PreviewMatches;
const InfoTooltip = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamRouting.previewMatchesTooltipAriaLabel', {
      defaultMessage: 'Additional information'
    }),
    type: 'question',
    content: _i18n.i18n.translate('xpack.streams.streamRouting.previewMatchesTooltipText', {
      defaultMessage: 'Approximate percentage of documents matching this condition over a random sample of documents.'
    }),
    iconProps: {
      style: {
        verticalAlign: 'text-bottom',
        marginLeft: 2
      }
    }
  });
};