"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kvProcessorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _condition = require("../../../../../../util/condition");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultFormState = {
  type: 'kv',
  field: '',
  field_split: '',
  value_split: '',
  target_field: '',
  include_keys: [],
  exclude_keys: [],
  prefix: '',
  trim_key: '',
  trim_value: '',
  strip_brackets: false,
  ignore_failure: true,
  ignore_missing: true,
  if: _condition.ALWAYS_CONDITION
};
const fieldOptions = {
  fieldHelpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvFieldHelpText', {
    defaultMessage: 'The field to be parsed.'
  }),
  includeCondition: true,
  includeIgnoreFailures: true,
  includeIgnoreMissing: true
};
const fieldConfigurations = [{
  field: 'field_split',
  type: 'string',
  required: true,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvFieldSplitLabel', {
    defaultMessage: 'Field split'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvFieldSplitHelpText",
    defaultMessage: "Regex pattern used to delimit the key-value pairs. Typically a space character ({character}).",
    values: {
      character: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "\" \"")
    }
  })
}, {
  field: 'value_split',
  type: 'string',
  required: true,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvValueSplitLabel', {
    defaultMessage: 'Value split'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvValueSplitHelpText",
    defaultMessage: "Regex pattern used to delimit the key from the value. Typically an equals sign ({character}).",
    values: {
      character: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "=")
    }
  })
}, {
  field: 'target_field',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvTargetFieldLabel', {
    defaultMessage: 'Target field'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvTargetFieldHelpText",
    defaultMessage: "The field to assign the parsed key-value pairs to. If not specified, the key-value pairs are assigned to the root of the document."
  })
}, {
  field: 'include_keys',
  type: 'array',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvIncludeKeysLabel', {
    defaultMessage: 'Include keys'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvIncludeKeysHelpText",
    defaultMessage: "A list of extracted keys to include in the output. If not specified, all keys are included by default."
  })
}, {
  field: 'exclude_keys',
  type: 'array',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvExcludeKeysLabel', {
    defaultMessage: 'Exclude keys'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvExcludeKeysHelpText",
    defaultMessage: "A list of extracted keys to exclude from the output."
  })
}, {
  field: 'prefix',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvPrefixLabel', {
    defaultMessage: 'Prefix'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvPrefixHelpText",
    defaultMessage: "A prefix to add to extracted keys."
  })
}, {
  field: 'trim_key',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvTrimKeyLabel', {
    defaultMessage: 'Trim key'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvTrimKeyHelpText",
    defaultMessage: "String of characters to trim from extracted keys."
  })
}, {
  field: 'trim_value',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvTrimValueLabel', {
    defaultMessage: 'Trim value'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvTrimValueHelpText",
    defaultMessage: "String of characters to trim from extracted values."
  })
}, {
  field: 'strip_brackets',
  type: 'boolean',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvStripBracketsLabel', {
    defaultMessage: 'Strip brackets'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvStripBracketsHelpText",
    defaultMessage: "Remove brackets ( {brackets}, {angularBrackets}, {squareBrackets}) and quotes ({singleQuote}, {doubleQuote}) from extracted values.",
    values: {
      brackets: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "()"),
      angularBrackets: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "<>"),
      squareBrackets: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "[]"),
      singleQuote: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "'"),
      doubleQuote: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "\"")
    }
  })
}];
const kvProcessorConfig = exports.kvProcessorConfig = {
  type: 'kv',
  inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.kvInputDisplay', {
    defaultMessage: 'Key-value (KV)'
  }),
  getDocUrl: docLinks => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.kvHelpText",
      defaultMessage: "Helps automatically parse messages (or specific event fields) which are of the {kvLink}",
      values: {
        kvLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsKvLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.kv
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.kvLinkLabel', {
          defaultMessage: 'foo=bar variety.'
        }))
      }
    });
  },
  defaultFormState,
  convertFormStateToConfig: (0, _utils.getConvertFormStateToConfig)('kv', fieldConfigurations, fieldOptions),
  convertProcessorToFormState: (0, _utils.getConvertProcessorToFormState)('kv', defaultFormState),
  fieldConfigurations,
  fieldOptions
};