"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetImage = AssetImage;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const imageSets = {
  welcome: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('./welcome_light.png'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('./welcome_dark.png'))),
    alt: _i18n.i18n.translate('xpack.streams.streamDetailView.welcomeImage', {
      defaultMessage: 'Welcome image for the streams app'
    })
  },
  noResults: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('./no_results_light.png'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('./no_results_dark.png'))),
    alt: _i18n.i18n.translate('xpack.streams.streamDetailView.noResultsImage', {
      defaultMessage: 'No results image for the streams app'
    })
  },
  significantEventsEmptyState: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('./sig_events_empty_state_light.png'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('./sig_events_empty_state_dark.png'))),
    alt: _i18n.i18n.translate('xpack.streams.significantEvents.emptyStateImage', {
      defaultMessage: 'Empty state illustration for the Significant events view'
    })
  },
  addStreams: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('./add_streams_light.png'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('./add_streams_dark.png'))),
    alt: _i18n.i18n.translate('xpack.streams.streamDetailView.addStreamsImage', {
      defaultMessage: 'Add streams image for the streams app'
    })
  },
  quickLinksEmpty: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('./quick_links_empty_light.png'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('./quick_links_empty_dark.png'))),
    alt: _i18n.i18n.translate('xpack.streams.streamDetailView.quickLinksEmptyImage', {
      defaultMessage: 'Quick links empty image for the streams app'
    })
  },
  unableToGeneratePreview: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('./unable_to_generate_preview_light.png'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('./unable_to_generate_preview_dark.png'))),
    alt: _i18n.i18n.translate('xpack.streams.streamDetailView.unableToGeneratePreviewImage', {
      defaultMessage: 'Unable to generate preview image for the streams app'
    })
  },
  yourPreviewWillAppearHere: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('./your_preview_will_appear_here_light.png'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('./your_preview_will_appear_here_dark.png'))),
    alt: _i18n.i18n.translate('xpack.streams.streamDetailView.yourPreviewWillAppearHereImage', {
      defaultMessage: 'Your preview will appear here image for the streams app'
    })
  },
  processorsCannotBeAddedToRootStreams: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('./processors_cannot_be_added_to_root_streams_light.png'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('./processors_cannot_be_added_to_root_streams_dark.png'))),
    alt: _i18n.i18n.translate('xpack.streams.streamDetailView.processorsCannotBeAddedToRootStreamsImage', {
      defaultMessage: 'Processors cannot be added to root streams image for the streams app'
    })
  }
};
function AssetImage({
  type = 'welcome',
  ...props
}) {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const {
    alt,
    dark,
    light
  } = imageSets[type];
  const [imageSrc, setImageSrc] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    let isMounted = true;
    const dynamicImageImport = colorMode === 'LIGHT' ? light() : dark();
    dynamicImageImport.then(module => {
      if (isMounted) {
        setImageSrc(module.default);
      }
    });
    return () => {
      isMounted = false;
    };
  }, [colorMode, dark, light]);
  return imageSrc ? /*#__PURE__*/_react.default.createElement(_eui.EuiImage, (0, _extends2.default)({
    size: "l"
  }, props, {
    alt: alt,
    src: imageSrc
  })) : null;
}