"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityDisabledCallout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SecurityDisabledCallout = ({
  enableSecurityLink
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "warning",
  "data-test-subj": "securityDisabledCallout",
  title: _i18n.i18n.translate('xpack.spaces.management.spaceDetails.contentTabs.securityDisabledTitle', {
    defaultMessage: 'Security features are disabled'
  })
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.spaces.management.spaceDetails.contentTabs.securityDisabledDescription",
  defaultMessage: "To manage space permissions, you must enable security features first. {learnMoreLink}",
  values: {
    learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: enableSecurityLink,
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.spaceDetails.contentTabs.securityDisabledLearnMore",
      defaultMessage: "Learn more"
    }))
  }
}));
exports.SecurityDisabledCallout = SecurityDisabledCallout;