"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../app_context");
var _components = require("../../../../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShardsTable = ({
  shards
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const Progress = ({
    total,
    restored,
    percent
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.progressTooltipLabel', {
      defaultMessage: '{restored} of {total} restored',
      values: {
        restored,
        total
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    size: "xs",
    textAlign: "center",
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: total === 0 ? 1 : restored,
    max: total === 0 ? 1 : total,
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), percent));
  const columns = [{
    field: 'id',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.indexColumnTitle', {
      defaultMessage: 'ID'
    }),
    width: '40px',
    render: (id, shard) => shard.primary ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, id), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.restoreList.shardTable.primaryTooltipLabel",
        defaultMessage: "Primary"
      })
    }, /*#__PURE__*/_react.default.createElement("strong", {
      tabIndex: 0
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreList.shardTable.primaryAbbreviationText",
      defaultMessage: "P",
      description: "Used as an abbreviation for 'Primary', as in 'Primary shard'"
    }))))) : id
  }, {
    field: 'stage',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.stageColumnTitle', {
      defaultMessage: 'Stage'
    })
  }, {
    field: 'startTimeInMillis',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.startTimeColumnTitle', {
      defaultMessage: 'Start time'
    }),
    render: startTimeInMillis => startTimeInMillis ? /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: startTimeInMillis
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })
  }, {
    field: 'stopTimeInMillis',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.endTimeColumnTitle', {
      defaultMessage: 'End time'
    }),
    render: stopTimeInMillis => stopTimeInMillis ? /*#__PURE__*/_react.default.createElement(_components.FormattedDateTime, {
      epochMs: stopTimeInMillis
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })
  }, {
    field: 'totalTimeInMillis',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.durationColumnTitle', {
      defaultMessage: 'Duration'
    }),
    render: totalTimeInMillis => totalTimeInMillis ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreList.shardTable.durationValue",
      defaultMessage: "{seconds} {seconds, plural, one {second} other {seconds}}",
      values: {
        seconds: Math.ceil(totalTimeInMillis / 1000)
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    })
  }, {
    field: 'repository',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.repositoryColumnTitle', {
      defaultMessage: 'Repository'
    })
  }, {
    field: 'snapshot',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.snapshotColumnTitle', {
      defaultMessage: 'Snapshot'
    })
  }, {
    field: 'version',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.versionColumnTitle', {
      defaultMessage: 'Version'
    })
  }, {
    field: 'targetHost',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.targetHostColumnTitle', {
      defaultMessage: 'Target host'
    })
  }, {
    field: 'targetNode',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.targetNodeColumnTitle', {
      defaultMessage: 'Target node'
    })
  }, {
    field: 'bytesTotal',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.bytesColumnTitle', {
      defaultMessage: 'Bytes'
    }),
    render: (bytesTotal, {
      bytesRecovered,
      bytesPercent
    }) => /*#__PURE__*/_react.default.createElement(Progress, {
      total: bytesTotal,
      restored: bytesRecovered,
      percent: bytesPercent
    })
  }, {
    field: 'filesTotal',
    name: i18n.translate('xpack.snapshotRestore.restoreList.shardTable.filesColumnTitle', {
      defaultMessage: 'Files'
    }),
    render: (filesTotal, {
      filesRecovered,
      filesPercent
    }) => /*#__PURE__*/_react.default.createElement(Progress, {
      total: filesTotal,
      restored: filesRecovered,
      percent: filesPercent
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: "snapshotRestore__shardsTable",
    compressed: true
    // @ts-ignore `shards` is a Partial<> but this component treats a number of fields as required
    ,
    items: shards,
    columns: columns
  });
};
exports.ShardsTable = ShardsTable;