"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/core/public");
var _common = require("../../common");
var _shared_imports = require("../shared_imports");
var _components = require("./components");
var _constants = require("./constants");
var _sections = require("./sections");
var _app_context = require("./app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const App = () => {
  const {
    slm_ui: slmUi
  } = (0, _app_context.useConfig)();
  const {
    apiError
  } = (0, _shared_imports.useAuthorizationContext)();
  const sections = ['repositories', 'snapshots', 'restore_status'];
  if (slmUi.enabled) {
    sections.push('policies');
  }
  const sectionsRegex = sections.join('|');
  return apiError ? /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.app.checkingPrivilegesErrorMessage",
      defaultMessage: "Error fetching user privileges from the server."
    }),
    error: apiError
  }) : /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
    privileges: _common.APP_REQUIRED_CLUSTER_PRIVILEGES.map(name => `cluster.${name}`)
  }, ({
    isLoading,
    hasPrivileges,
    privilegesMissing
  }) => isLoading ? /*#__PURE__*/_react.default.createElement(_components.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.app.checkingPrivilegesDescription",
    defaultMessage: "Checking privileges\u2026"
  })) : hasPrivileges ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "snapshotRestoreApp",
    className: _public.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/add_repository",
    component: _sections.RepositoryAdd
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/edit_repository/:name*",
    component: _sections.RepositoryEdit
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `/:section(${sectionsRegex})/:repositoryName?/:snapshotId*`,
    component: _sections.SnapshotRestoreHome
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    from: "/restore/:repositoryName",
    to: "/snapshots"
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/restore/:repositoryName/:snapshotId*",
    component: _sections.RestoreSnapshot
  }), slmUi.enabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/add_policy",
    component: _sections.PolicyAdd
  }), slmUi.enabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/edit_policy/:name*",
    component: _sections.PolicyEdit
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: "/",
    to: `/${_constants.DEFAULT_SECTION}`
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: "",
    to: `/${_constants.DEFAULT_SECTION}`
  }))) : /*#__PURE__*/_react.default.createElement(_shared_imports.NotAuthorizedSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.app.deniedPrivilegeTitle",
      defaultMessage: "You're missing cluster privileges"
    }),
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.app.deniedPrivilegeDescription",
      defaultMessage: "To use Snapshot and Restore, you must have {privilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {missingPrivileges}.",
      values: {
        missingPrivileges: privilegesMissing.cluster.join(', '),
        privilegesCount: privilegesMissing.cluster.length
      }
    })
  }));
};
exports.App = App;