"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLazyWithContextProviders = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireWildcard(require("react"));
var _plugin_context = require("../context/plugin_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLazyWithContextProviders = ({
  core,
  plugins,
  observabilityRuleTypeRegistry,
  ObservabilityPageTemplate,
  isDev,
  kibanaVersion,
  isServerless,
  experimentalFeatures,
  sloClient
}) => (LazyComponent, options) => {
  const {
    spinnerSize = 'xl'
  } = options !== null && options !== void 0 ? options : {};
  const queryClient = new _reactQuery.QueryClient();
  return props => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage: new _public2.Storage(localStorage),
      isDev,
      kibanaVersion,
      isServerless
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
    value: {
      isDev,
      observabilityRuleTypeRegistry,
      ObservabilityPageTemplate,
      experimentalFeatures,
      sloClient
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(LoadingSpinner, {
      size: spinnerSize
    })
  }, /*#__PURE__*/_react.default.createElement(LazyComponent, props)))));
};
exports.getLazyWithContextProviders = getLazyWithContextProviders;
function LoadingSpinner({
  size
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: size
  })));
}