"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TechnicalPreviewBadge = TechnicalPreviewBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TechnicalPreviewBadge() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.slo.technicalPreviewBadgeTitle', {
      defaultMessage: 'Technical Preview'
    }),
    size: "s",
    tooltipPosition: "bottom",
    tooltipContent: _i18n.i18n.translate('xpack.slo.technicalPreviewBadgeDescription', {
      defaultMessage: 'This functionality is in technical preview and is subject to change or may be removed in future versions. The design and code is less mature than official generally available features and is being provided as-is with no warranties. Technical preview features are not subject to the support service level agreement of official generally available features.'
    })
  });
}