"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkAndInitPrivilegedMonitoringResources = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * As internal user we check for existence of privilege monitoring resources.
 * and initialise it if it does not exist
 * @param context
 * @param logger
 */
const checkAndInitPrivilegedMonitoringResources = async (context, logger) => {
  const secSol = await context.securitySolution;
  const privMonDataClient = secSol.getPrivilegeMonitoringDataClient();
  await privMonDataClient.createIngestPipelineIfDoesNotExist();
  const doesIndexExist = await privMonDataClient.doesIndexExist();
  if (!doesIndexExist) {
    logger.info('Privilege monitoring index does not exist, initialising.');
    await privMonDataClient.createOrUpdateIndex().catch(e => {
      if (e.meta.body.error.type === 'resource_already_exists_exception') {
        logger.info('Privilege monitoring index already exists');
      }
    });
    logger.info('Privilege monitoring resources installed');
  }
};
exports.checkAndInitPrivilegedMonitoringResources = checkAndInitPrivilegedMonitoringResources;