"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildStatusesKuery = buildStatusesKuery;
var _services = require("@kbn/fleet-plugin/common/services");
var _types = require("../../../../../common/endpoint/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_QUERY_MAP = new Map([[_types.HostStatus.HEALTHY.toString(), _services.AgentStatusKueryHelper.buildKueryForOnlineAgents()], [_types.HostStatus.OFFLINE.toString(), _services.AgentStatusKueryHelper.buildKueryForOfflineAgents()], [_types.HostStatus.UNHEALTHY.toString(), _services.AgentStatusKueryHelper.buildKueryForErrorAgents()], [_types.HostStatus.UPDATING.toString(), _services.AgentStatusKueryHelper.buildKueryForUpdatingAgents()], [_types.HostStatus.INACTIVE.toString(), _services.AgentStatusKueryHelper.buildKueryForInactiveAgents()], [_types.HostStatus.UNENROLLED.toString(), _services.AgentStatusKueryHelper.buildKueryForUnenrolledAgents()]]);
function buildStatusesKuery(statusesToFilter) {
  if (!statusesToFilter.length) {
    return;
  }
  const statusQueries = statusesToFilter.map(status => STATUS_QUERY_MAP.get(status));
  if (!statusQueries.length) {
    return;
  }
  return `(${statusQueries.join(' OR ')})`;
}