"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserHostWorkingDir = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var _host_working_dir = require("./host_working_dir");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserHostWorkingDir = exports.UserHostWorkingDir = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  hostName,
  hostNameSeparator = '@',
  userDomain,
  userDomainField = 'user.domain',
  userName,
  userNameField = 'user.name',
  workingDirectory,
  scopeId
}) => userName != null || userDomain != null || hostName != null || workingDirectory != null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  eventId: eventId,
  field: userNameField,
  value: userName,
  iconType: "user",
  fieldType: "keyword",
  isAggregatable: true,
  scopeId: scopeId
})), userDomain != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  "data-test-subj": "user-host-working-dir-domain-separator-text",
  grow: false,
  component: "span"
}, '\\'), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  eventId: eventId,
  field: userDomainField,
  value: userDomain,
  fieldType: "keyword",
  isAggregatable: true,
  scopeId: scopeId
}))), hostName != null && userName != null && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, hostNameSeparator), /*#__PURE__*/_react.default.createElement(_host_working_dir.HostWorkingDir, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: eventId,
  hostName: hostName,
  workingDirectory: workingDirectory
})) : null);
UserHostWorkingDir.displayName = 'UserHostWorkingDir';