"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Participants = exports.PARTICIPANTS = exports.CREATED_BY = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PARTICIPANTS = exports.PARTICIPANTS = _i18n.i18n.translate('xpack.securitySolution.timeline.notes.participantsTitle', {
  defaultMessage: 'Participants'
});
const CREATED_BY = exports.CREATED_BY = _i18n.i18n.translate('xpack.securitySolution.timeline notes.createdByLabel', {
  defaultMessage: 'Created by'
});
/**
 * Renders the username with an avatar
 */
const UsernameWithAvatar = /*#__PURE__*/_react2.default.memo(({
  username,
  'data-test-subj': dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    css: (0, _react.css)`
          flex-grow: 0;
        `,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAvatar, {
    "data-test-subj": "avatar",
    name: username,
    size: "l"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-weight: ${euiTheme.font.weight.bold};
            `
  }, username)));
});
UsernameWithAvatar.displayName = 'UsernameWithAvatar';
/**
 * Renders all the users that are participating to the timeline
 * - the user who created the timeline
 * - all the unique users who created notes associated with the timeline
 */
const Participants = exports.Participants = /*#__PURE__*/_react2.default.memo(({
  notes,
  timelineCreatedBy
}) => {
  // filter for savedObjectId to make sure we don't display `elastic` user while saving the note
  const participants = (0, _react2.useMemo)(() => (0, _fp.uniqBy)('updatedBy', (0, _fp.filter)('noteId', notes)), [notes]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, timelineCreatedBy && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": _test_ids.TIMELINE_PARTICIPANT_TITLE_TEST_ID
  }, /*#__PURE__*/_react2.default.createElement("h4", null, CREATED_BY)), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react2.default.createElement(UsernameWithAvatar, {
    username: timelineCreatedBy,
    "data-test-subj": _test_ids.TIMELINE_AVATAR_WITH_NAME_TEST_ID
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  })), /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": _test_ids.NOTES_PARTICIPANTS_TITLE_TEST_ID
  }, /*#__PURE__*/_react2.default.createElement("h4", null, PARTICIPANTS)), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), participants.map((participant, index) => /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
    key: participant.updatedBy === null ? undefined : participant.updatedBy
  }, /*#__PURE__*/_react2.default.createElement(UsernameWithAvatar, {
    key: participant.updatedBy === null ? undefined : participant.updatedBy,
    username: String(participant.updatedBy),
    "data-test-subj": `${_test_ids.NOTE_AVATAR_WITH_NAME_TEST_ID}-${index}`
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))));
});
Participants.displayName = 'Participants';