"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMigrationRulesTableColumns = void 0;
var _react = require("react");
var _rules_table_columns = require("../components/rules_table_columns");
var _integrations = require("../components/rules_table_columns/integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMigrationRulesTableColumns = ({
  disableActions,
  openMigrationRuleDetails,
  installMigrationRule,
  getMigrationRuleData
}) => {
  return (0, _react.useMemo)(() => [(0, _rules_table_columns.createUpdatedColumn)(), (0, _rules_table_columns.createNameColumn)({
    openMigrationRuleDetails
  }), (0, _rules_table_columns.createStatusColumn)(), (0, _rules_table_columns.createRiskScoreColumn)(), (0, _rules_table_columns.createSeverityColumn)(), (0, _rules_table_columns.createAuthorColumn)(), (0, _integrations.createIntegrationsColumn)({
    getMigrationRuleData
  }), (0, _rules_table_columns.createActionsColumn)({
    disableActions,
    openMigrationRuleDetails,
    installMigrationRule
  })], [disableActions, getMigrationRuleData, installMigrationRule, openMigrationRuleDetails]);
};
exports.useMigrationRulesTableColumns = useMigrationRulesTableColumns;