"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledGraphControlsColumn = exports.StyledGraphControls = exports.StyledEuiRange = exports.StyledEuiDescriptionListTitle = exports.StyledEuiDescriptionListDescription = exports.StyledEuiButtonIcon = exports.COLUMN_WIDTH = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COLUMN_WIDTH = exports.COLUMN_WIDTH = ['fit-content(10em)', 'auto'];

// EuiRange is currently only horizontally positioned. This reorients the track to a vertical position
const StyledEuiRange = exports.StyledEuiRange = (0, _styledComponents.default)(_eui.EuiRange)`
  & .euiRangeTrack:after {
    left: -65px;
    transform: rotate(90deg);
  }
`;
const StyledGraphControlsColumn = exports.StyledGraphControlsColumn = _styledComponents.default.div`
  display: flex;
  flex-direction: column;

  &:not(last-of-type) {
    margin-right: 5px;
  }
`;
const StyledEuiDescriptionListTitle = exports.StyledEuiDescriptionListTitle = (0, _styledComponents.default)(_eui.EuiDescriptionListTitle)`
  text-transform: uppercase;
`;
const StyledEuiDescriptionListDescription = exports.StyledEuiDescriptionListDescription = (0, _styledComponents.default)(_eui.EuiDescriptionListDescription)`
  lineheight: '2.2em'; // lineHeight to align center vertically
`;
const StyledEuiButtonIcon = exports.StyledEuiButtonIcon = (0, _styledComponents.default)(_eui.EuiButtonIcon)`
  background-color: ${props => props.$backgroundColor};
  color: ${props => props.$iconColor};
  border-color: ${props => props.$borderColor};
  border-width: 1px;
  border-style: solid;
  border-radius: 4px;
  width: 40px;
  height: 40px;

  &:not(last-of-type) {
    margin-bottom: 7px;
  }
`;
const StyledGraphControls = exports.StyledGraphControls = _styledComponents.default.div`
  display: flex;
  flex-direction: row;
  position: absolute;
  top: 5px;
  right: 5px;
  background-color: transparent;
  color: ${props => props.$iconColor};

  .zoom-controls {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 5px 0px;

    .zoom-slider {
      width: 20px;
      height: 150px;
      margin: 5px 0px 2px 0px;

      input[type='range'] {
        width: 150px;
        height: 20px;
        transform-origin: 75px 75px;
        transform: rotate(-90deg);
      }
    }
  }
  .panning-controls {
    text-align: center;
  }
`;