"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionResponse = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("../../../common");
var _constants = require("../../common/store/inputs/constants");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _soc_trends = require("../components/detection_response/soc_trends");
var _search_bar = require("../../common/components/search_bar");
var _page_wrapper = require("../../common/components/page_wrapper");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _types = require("../../app/types");
var _containers = require("../../sourcerer/containers");
var _use_signal_index = require("../../detections/containers/detection_engine/alerts/use_signal_index");
var _use_alerts_privileges = require("../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _header_page = require("../../common/components/header_page");
var _empty_prompt = require("../../common/components/empty_prompt");
var _alerts_by_status = require("../components/detection_response/alerts_by_status");
var _host_alerts_table = require("../components/detection_response/host_alerts_table");
var _rule_alerts_table = require("../components/detection_response/rule_alerts_table");
var _user_alerts_table = require("../components/detection_response/user_alerts_table");
var i18n = _interopRequireWildcard(require("./translations"));
var _cases_table = require("../components/detection_response/cases_table");
var _cases_by_status = require("../components/detection_response/cases_by_status");
var _no_privileges = require("../../common/components/no_privileges");
var _filters_global = require("../../common/components/filters_global");
var _use_global_filter_query = require("../../common/hooks/use_global_filter_query");
var _kibana = require("../../common/lib/kibana");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _page_loader = require("../../common/components/page_loader");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetectionResponseComponent = () => {
  var _experimentalDataView;
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const {
    indicesExist: oldIndicesExist,
    loading: oldIsSourcererLoading,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)();
  const indicesExist = newDataViewPickerEnabled ? !!((_experimentalDataView = experimentalDataView.matchedIndices) !== null && _experimentalDataView !== void 0 && _experimentalDataView.length) : oldIndicesExist;
  const isSourcererLoading = newDataViewPickerEnabled ? status !== 'ready' : oldIsSourcererLoading;
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    hasKibanaREAD,
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const userCasesPermissions = cases.helpers.canUseCases([_common.APP_ID]);
  const canReadCases = userCasesPermissions.read;
  const canReadAlerts = hasKibanaREAD && hasIndexRead;
  const isSocTrendsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('socTrendsEnabled');
  const additionalFilters = (0, _react.useMemo)(() => filterQuery ? [filterQuery] : [], [filterQuery]);
  if (!canReadAlerts && !canReadCases) {
    return /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivileges, {
      docLinkSelector: docLinks => docLinks.siem.privileges
    });
  }
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    sourcererDataView: oldSourcererDataView // TODO: newDataViewPicker - Can be removed after migration to new dataview picker
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    "data-test-subj": "detectionResponsePage"
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.DETECTION_RESPONSE_TITLE
  }), isSourcererLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    "data-test-subj": "detectionResponseLoader"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "detectionResponseSections"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, canReadAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alerts_by_status.AlertsByStatus, {
    signalIndexName: signalIndexName,
    additionalFilters: additionalFilters
  })), canReadCases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cases_by_status.CasesByStatus, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, canReadAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rule_alerts_table.RuleAlertsTable, {
    signalIndexName: signalIndexName
  })), canReadCases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cases_table.CasesTable, null)))), isSocTrendsEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_soc_trends.SocTrends, {
    signalIndexName: signalIndexName
  })))), canReadAlerts && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_host_alerts_table.HostAlertsTable, {
    signalIndexName: signalIndexName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_user_alerts_table.UserAlertsTable, {
    signalIndexName: signalIndexName
  }))))))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.detectionAndResponse
  }));
};
const DetectionResponse = exports.DetectionResponse = /*#__PURE__*/_react.default.memo(DetectionResponseComponent);