"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTriggerScan = void 0;
var _reactQuery = require("@kbn/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _use_fetch_anonymization_fields = require("@kbn/elastic-assistant/impl/assistant/api/anonymization_fields/use_fetch_anonymization_fields");
var _kibana = require("../../../../../../common/lib/kibana");
var _translations = require("../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTriggerScan = ({
  onSuccess
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const toasts = (0, _kibana.useToasts)();
  const {
    data: anonymizationFields
  } = (0, _use_fetch_anonymization_fields.useFetchAnonymizationFields)();
  return (0, _reactQuery.useMutation)(({
    endpointId,
    connectorId,
    actionTypeId
  }) => http.post(_elasticAssistantCommon.DEFEND_INSIGHTS, {
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    body: JSON.stringify({
      endpointIds: [endpointId],
      insightType: _elasticAssistantCommon.DefendInsightTypeEnum.incompatible_antivirus,
      anonymizationFields: anonymizationFields.data,
      replacements: {},
      subAction: 'invokeAI',
      apiConfig: {
        connectorId,
        actionTypeId
      }
    })
  }), {
    onSuccess,
    onError: err => {
      var _err$body;
      toasts.addDanger({
        title: _translations.WORKFLOW_INSIGHTS.toasts.scanError,
        text: (_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.error
      });
    }
  });
};
exports.useTriggerScan = useTriggerScan;