"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderDataCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../common/entity_analytics/types");
var _use_generic_entity_criticality = require("./hooks/use_generic_entity_criticality");
var _asset_criticality_selector = require("../../../entity_analytics/components/asset_criticality/asset_criticality_selector");
var _responsive_data_cards = require("./components/responsive_data_cards");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderDataCards = ({
  id,
  subType,
  type
}) => {
  var _getAssetCriticality$2, _assignAssetCriticali, _assignAssetCriticali2;
  const {
    getAssetCriticality,
    assignAssetCriticality
  } = (0, _use_generic_entity_criticality.useGenericEntityCriticality)({
    idField: _types.EntityIdentifierFields.generic,
    idValue: id
  });
  const cards = (0, _react.useMemo)(() => {
    var _getAssetCriticality$;
    return [{
      title: _i18n.i18n.translate('xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.criticalityLabel', {
        defaultMessage: 'Criticality'
      }),
      description: /*#__PURE__*/_react.default.createElement("div", {
        css: (0, _react2.css)`
              width: fit-content;
            `
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
        popoverProps: {
          repositionOnScroll: true,
          panelMinWidth: 200
        },
        fullWidth: false,
        compressed: true,
        hasDividers: true,
        options: _asset_criticality_selector.assetCriticalityOptions,
        valueOfSelected: ((_getAssetCriticality$ = getAssetCriticality.data) === null || _getAssetCriticality$ === void 0 ? void 0 : _getAssetCriticality$.criticality_level) || 'unassigned',
        onChange: newValue => {
          assignAssetCriticality.mutate({
            criticalityLevel: newValue,
            idField: _types.EntityIdentifierFields.generic,
            idValue: id
          });
        },
        isInvalid: assignAssetCriticality.isError
      }))
    }, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: 'spaceBetween',
        wrap: false,
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, 'ID'), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
        textToCopy: id
      }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: copy,
        iconType: "document",
        color: "text"
      })))),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        text: id
      })
    }, {
      title: _i18n.i18n.translate('xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.typeLabel', {
        defaultMessage: 'Type'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        text: type || ''
      })
    }, {
      title: _i18n.i18n.translate('xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.subtypeLabel', {
        defaultMessage: 'Sub Type'
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
        text: subType || ''
      })
    }];
  }, [(_getAssetCriticality$2 = getAssetCriticality.data) === null || _getAssetCriticality$2 === void 0 ? void 0 : _getAssetCriticality$2.criticality_level, id, type, subType, assignAssetCriticality]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, assignAssetCriticality.isError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    onDismiss: () => {
      assignAssetCriticality.reset();
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.assignCriticalityErrorTitle",
      defaultMessage: "We could not assign the selected criticality"
    }),
    color: "danger",
    iconType: "error"
  }, /*#__PURE__*/_react.default.createElement("p", null, ((_assignAssetCriticali = assignAssetCriticality.error) === null || _assignAssetCriticali === void 0 ? void 0 : (_assignAssetCriticali2 = _assignAssetCriticali.body) === null || _assignAssetCriticali2 === void 0 ? void 0 : _assignAssetCriticali2.message) || _i18n.i18n.translate('xpack.securitySolution.genericEntityFlyout.flyoutHeader.headerDataBoxes.assignCriticalityErrorText', {
    defaultMessage: 'Something went wrong during validation. Please try again.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_responsive_data_cards.ResponsiveDataCards, {
    cards: cards,
    collapseWidth: 750
  }));
};
exports.HeaderDataCards = HeaderDataCards;