"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LeftPanelVisualizeTab = exports.LeftPanelResponseTab = exports.LeftPanelNotesTab = exports.LeftPanelInvestigationTab = exports.LeftPanelInsightsTab = exports.LeftPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _user_privileges = require("../../../common/components/user_privileges");
var _panel_keys = require("../shared/constants/panel_keys");
var _kibana = require("../../../common/lib/kibana");
var _header = require("./header");
var _content = require("./content");
var tabs = _interopRequireWildcard(require("./tabs"));
var _utils = require("../shared/utils");
var _event_kinds = require("../shared/constants/event_kinds");
var _context = require("../shared/context");
var _types = require("../../../common/lib/telemetry/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LeftPanelVisualizeTab = exports.LeftPanelVisualizeTab = 'visualize';
const LeftPanelInsightsTab = exports.LeftPanelInsightsTab = 'insights';
const LeftPanelInvestigationTab = exports.LeftPanelInvestigationTab = 'investigation';
const LeftPanelResponseTab = exports.LeftPanelResponseTab = 'response';
const LeftPanelNotesTab = exports.LeftPanelNotesTab = 'notes';
const LeftPanel = exports.LeftPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    scopeId,
    getFieldsData,
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const eventKind = (0, _utils.getField)(getFieldsData('event.kind'));
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  const {
    notesPrivileges: {
      read: canSeeNotes
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const tabsDisplayed = (0, _react.useMemo)(() => {
    const tabList = eventKind === _event_kinds.EventKind.signal ? [tabs.insightsTab, tabs.investigationTab, tabs.responseTab] : [tabs.insightsTab];
    if (canSeeNotes && !securitySolutionNotesDisabled && !isRulePreview) {
      tabList.push(tabs.notesTab);
    }
    if (!isRulePreview) {
      return [tabs.visualizeTab, ...tabList];
    }
    return tabList;
  }, [eventKind, isRulePreview, canSeeNotes, securitySolutionNotesDisabled]);
  const selectedTabId = (0, _react.useMemo)(() => {
    var _tabsDisplayed$map$fi;
    const defaultTab = tabsDisplayed[0].id;
    if (!path) return defaultTab;
    return (_tabsDisplayed$map$fi = tabsDisplayed.map(tab => tab.id).find(tabId => tabId === path.tab)) !== null && _tabsDisplayed$map$fi !== void 0 ? _tabsDisplayed$map$fi : defaultTab;
  }, [path, tabsDisplayed]);
  const setSelectedTabId = tabId => {
    openLeftPanel({
      id: _panel_keys.DocumentDetailsLeftPanelKey,
      path: {
        tab: tabId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
    telemetry.reportEvent(_types.DocumentEventTypes.DetailsFlyoutTabClicked, {
      location: scopeId,
      panel: 'left',
      tabId
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId,
    tabs: tabsDisplayed
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    selectedTabId: selectedTabId,
    tabs: tabsDisplayed
  }));
});
LeftPanel.displayName = 'LeftPanel';