"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoresNoDataDetected = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _risk_score_header_title = require("./risk_score_header_title");
var _header_section = require("../../common/components/header_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoresNoDataDetectedComponent = ({
  entityType
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `${entityType}-risk-score-no-data-detected`,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      riskScoreEntity: entityType
    }),
    titleSize: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.entityDashboardWarningPanelTitle",
      defaultMessage: "No {entityType} risk score data available to display",
      values: {
        entityType
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.entityDashboardWarningPanelBody",
      defaultMessage: `We haven’t found any {entityType} risk score data. Check if you have any global filters in the global KQL search bar. If you have just enabled the {entityType} risk module, the risk engine might need an hour to generate {entityType} risk score data and display in this panel.`,
      values: {
        entityType
      }
    })
  }));
};
const RiskScoresNoDataDetected = exports.RiskScoresNoDataDetected = /*#__PURE__*/_react.default.memo(RiskScoresNoDataDetectedComponent);
RiskScoresNoDataDetected.displayName = 'RiskScoresNoDataDetected';