"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringFilePickerStep = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _formatted_bytes = require("../../../../../../common/components/formatted_bytes");
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const privilegedUserMonitoringCSVSample = ['superadmin', 'admin01,Domain Admin', 'sec_ops', 'jdoe,IT Support'];
const PrivilegedUserMonitoringFilePickerStep = exports.PrivilegedUserMonitoringFilePickerStep = /*#__PURE__*/_react.default.memo(({
  onFileChange,
  errorMessage,
  isLoading
}) => {
  const formatBytes = (0, _formatted_bytes.useFormatBytes)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const listStyle = (0, _css.css)`
      list-style-type: disc;
      margin-bottom: ${euiTheme.size.l};
      margin-left: ${euiTheme.size.l};
      line-height: ${(0, _eui.useEuiFontSize)('s').lineHeight};
    `;
  const sampleCSVContent = privilegedUserMonitoringCSVSample.join('\n');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "l",
    grow: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Supported file formats and size",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.csvFileFormatRequirements"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("ul", {
    className: listStyle
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "File formats: {formats}",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.acceptedFileFormats",
    values: {
      formats: _constants2.SUPPORTED_FILE_EXTENSIONS.join(', ')
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Maximum file size: {maxFileSize}",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.uploadFileSizeLimit",
    values: {
      maxFileSize: formatBytes(_constants.CRITICALITY_CSV_MAX_SIZE_BYTES)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "File structure",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.CSVStructureTitle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("ul", {
    className: listStyle
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{field}: privileged user\u2019s name",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.userNameDescription",
    values: {
      field: /*#__PURE__*/_react.default.createElement("code", null, 'user.name')
    }
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{field} (optional): user role, group, team, or similar",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.userLabelDescription",
    values: {
      field: /*#__PURE__*/_react.default.createElement("code", null, 'user.label')
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Example",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.exampleTitle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "csv",
    css: (0, _css.css)`
              background-color: ${euiTheme.colors.emptyShade};
            `,
    paddingSize: "s",
    lineNumbers: true,
    isCopyable: true
  }, sampleCSVContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    "data-test-subj": "privileged-user-monitoring-file-picker",
    accept: _constants2.SUPPORTED_FILE_TYPES.join(','),
    fullWidth: true,
    onChange: onFileChange,
    isInvalid: !!errorMessage,
    isLoading: isLoading,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.filePicker.AriaLabel', {
      defaultMessage: 'Privileged user monitoring file picker'
    })
  }), /*#__PURE__*/_react.default.createElement("br", null), errorMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "xs"
  }, errorMessage));
});
PrivilegedUserMonitoringFilePickerStep.displayName = 'PrivilegedUserMonitoringFilePickerStep';