"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PRIVILEGED_USER_ACTIVITY_QUERY_ID = exports.PAGE_SIZE = exports.GRANTED_RIGHTS_STACK_BY = exports.ERROR_ENCODING_ESQL_QUERY = exports.AUTHENTICATIONS_STACK_BY = exports.ACCOUNT_SWITCH_STACK_BY = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRIVILEGED_USER_ACTIVITY_QUERY_ID = exports.PRIVILEGED_USER_ACTIVITY_QUERY_ID = 'privileged-user-activity-query';
const PAGE_SIZE = exports.PAGE_SIZE = 10;
const privilegedUserOption = {
  text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.stackBy.privilegedUser",
    defaultMessage: "Privileged user"
  }),
  value: 'privileged_user'
};
const sourceIpOption = {
  text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.stackBy.sourceIp",
    defaultMessage: "Source IP"
  }),
  value: 'host_ip'
};
const GRANTED_RIGHTS_STACK_BY = exports.GRANTED_RIGHTS_STACK_BY = [privilegedUserOption, {
  text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.stackBy.targetUser",
    defaultMessage: "Target user"
  }),
  value: 'target_user'
}, {
  text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.stackBy.grantedRight",
    defaultMessage: "Granted right"
  }),
  value: 'group_name'
}, sourceIpOption];
const ACCOUNT_SWITCH_STACK_BY = exports.ACCOUNT_SWITCH_STACK_BY = [privilegedUserOption, {
  text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.stackBy.targetAccount",
    defaultMessage: "Target account"
  }),
  value: 'target_user'
}, {
  text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.stackBy.targetAdminGroup",
    defaultMessage: "Target admin group"
  }),
  value: 'group_name'
}, sourceIpOption];
const AUTHENTICATIONS_STACK_BY = exports.AUTHENTICATIONS_STACK_BY = [privilegedUserOption, {
  text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.stackBy.source",
    defaultMessage: "Source"
  }),
  value: 'source'
}, {
  text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.stackBy.type",
    defaultMessage: "Type"
  }),
  value: 'type'
}, sourceIpOption];
const ERROR_ENCODING_ESQL_QUERY = exports.ERROR_ENCODING_ESQL_QUERY = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.errorEncodingEsqlQuery",
  defaultMessage: "Error encoding ES|QL query for Discover view"
});