"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineStatusHeaderAction = EngineStatusHeaderAction;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_entity_store = require("../../../hooks/use_entity_store");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EngineStatusHeaderAction({
  engine,
  type
}) {
  var _engine$components;
  const enableEntityStore = (0, _use_entity_store.useEnableEntityStoreMutation)();
  const installEntityStore = () => {
    enableEntityStore.mutate({
      entityTypes: [type]
    });
  };
  const hasUninstalledComponent = engine === null || engine === void 0 ? void 0 : (_engine$components = engine.components) === null || _engine$components === void 0 ? void 0 : _engine$components.some(({
    installed
  }) => !installed);
  if (enableEntityStore.isLoading || (0, _helpers.isEngineLoading)(engine === null || engine === void 0 ? void 0 : engine.status)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    });
  }
  if (!engine) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: installEntityStore
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.installButton",
      defaultMessage: "Install"
    }));
  }
  if (hasUninstalledComponent) {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: installEntityStore,
      iconType: "refresh",
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.reinstallButton",
      defaultMessage: "Reinstall"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.entityStore.enginesStatus.reinstallToolTip",
        defaultMessage: "The components associated with this entity type are experiencing issues. Reinstall them to restore functionality"
      }),
      color: "warning",
      position: "right",
      type: "info"
    }));
  }
  return null;
}