"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionIconItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("../../../timelines/components/timeline/styles");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionIconItemComponent = ({
  width = _.DEFAULT_ACTION_BUTTON_WIDTH,
  dataTestSubj,
  content,
  ariaLabel,
  iconType = '',
  isDisabled = false,
  onClick,
  children,
  buttonType = 'icon'
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, buttonType === 'icon' && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
  textAlign: "center",
  width: width
}, children !== null && children !== void 0 ? children : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  "data-test-subj": `${dataTestSubj}-tool-tip`,
  content: content
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "aria-label": ariaLabel,
  "data-test-subj": `${dataTestSubj}-button`,
  iconType: iconType,
  isDisabled: isDisabled,
  onClick: onClick,
  size: "s",
  color: "text"
})))), buttonType === 'text' && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
  "aria-label": ariaLabel,
  "data-test-subj": `${dataTestSubj}-button-menu-item`,
  disabled: isDisabled,
  onClick: onClick,
  color: "text",
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  "data-test-subj": `${dataTestSubj}-button`,
  size: "m"
}, content)), buttonType === 'emptyButton' && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: onClick,
  iconType: "timeline",
  flush: "right",
  size: "xs",
  "data-test-subj": dataTestSubj
}, content));
ActionIconItemComponent.displayName = 'ActionIconItemComponent';
const ActionIconItem = exports.ActionIconItem = /*#__PURE__*/_react.default.memo(ActionIconItemComponent);