"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenerationTiming = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = _interopRequireDefault(require("react"));
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _formatted_date = require("../../../../../../common/components/formatted_date");
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenerationTimingComponent = ({
  interval
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "generationTiming",
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    css: (0, _react.css)`
            max-width: ${_helpers.MAX_SECONDS_BADGE_WIDTH}px;
          `,
    color: "hollow",
    "data-test-subj": "clockBadge",
    iconType: "clock"
  }, /*#__PURE__*/_react2.default.createElement("span", null, Math.trunc(interval.durationMs / 1000), i18n.SECONDS_ABBREVIATION))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
            margin-left: ${euiTheme.size.s};
          `,
    color: isDarkMode ? 'subdued' : 'default',
    "data-test-subj": "date",
    size: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: (0, _moment.default)(interval.date).toDate()
  }))));
};
GenerationTimingComponent.displayName = 'GenerationTimingComponent';
const GenerationTiming = exports.GenerationTiming = /*#__PURE__*/_react2.default.memo(GenerationTimingComponent);