"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleStat = SampleStat;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _label = require("./label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SampleStat({
  samples,
  diffSamples,
  totalSamples
}) {
  const samplesLabel = samples.toLocaleString();
  if (diffSamples === undefined || diffSamples === 0 || totalSamples === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, samplesLabel);
  }
  const percentDelta = diffSamples / (samples - diffSamples) * 100;
  const totalPercentDelta = diffSamples / totalSamples * 100;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, samplesLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_label.Label, {
    value: percentDelta,
    append: " rel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_label.Label, {
    value: totalPercentDelta,
    append: " abs"
  })));
}