"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerApp = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
var _features = require("../common/features");
var _constants = require("../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const registerApp = ({
  core,
  getServices
}) => {
  const isToolsPageEnabled = core.uiSettings.get(_constants.ONECHAT_TOOLS_UI_SETTING_ID, false);
  core.application.register({
    id: _features.ONECHAT_APP_ID,
    appRoute: _features.ONECHAT_PATH,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.chat,
    title: _features.ONECHAT_TITLE,
    euiIconType: 'logoElasticsearch',
    visibleIn: ['sideNav', 'globalSearch'],
    deepLinks: [{
      id: 'conversations',
      path: '/conversations',
      title: _i18n.i18n.translate('xpack.onechat.chat.conversationsTitle', {
        defaultMessage: 'Conversations'
      })
    }, ...(isToolsPageEnabled ? [{
      id: 'tools',
      path: '/tools',
      title: _i18n.i18n.translate('xpack.onechat.tools.title', {
        defaultMessage: 'Tools'
      })
    }] : [])],
    async mount({
      element,
      history
    }) {
      const {
        mountApp
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
      const [coreStart, startPluginDeps] = await core.getStartServices();
      coreStart.chrome.docTitle.change(_features.ONECHAT_TITLE);
      const services = getServices();
      return mountApp({
        core: coreStart,
        services,
        element,
        history,
        plugins: startPluginDeps
      });
    }
  });
};
exports.registerApp = registerApp;