"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerProfilingComponent = exports.getProfilingComponent = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registry = {};
const registerProfilingComponent = (key, component) => {
  if (registry[key] !== undefined) {
    throw new Error(_i18n.i18n.translate('xpack.observabilityShared.profilingComponentAlreadyExists.error', {
      defaultMessage: `Component with key {key} already exists`,
      values: {
        key
      }
    }));
  }
  registry[key] = component;
};
exports.registerProfilingComponent = registerProfilingComponent;
const getProfilingComponent = key => {
  if (registry[key] === undefined) {
    throw new Error(_i18n.i18n.translate('xpack.observabilityShared.profilingComponentNotFound.error', {
      defaultMessage: `Component with key {key} not found`,
      values: {
        key
      }
    }));
  }
  return registry[key];
};
exports.getProfilingComponent = getProfilingComponent;