"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChartOptions = getChartOptions;
var _legacy_shims = require("../../legacy_shims");
var _lodash = require("lodash");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getChartOptions(axisOptions) {
  var _Legacy$shims$uiSetti;
  const timezone = (_Legacy$shims$uiSetti = _legacy_shims.Legacy.shims.uiSettings) === null || _Legacy$shims$uiSetti === void 0 ? void 0 : _Legacy$shims$uiSetti.get('dateFormat:tz');
  const opts = {
    legend: {
      show: false
    },
    xaxis: {
      color: _constants.CHART_LINE_COLOR,
      timezone: timezone === 'Browser' ? 'browser' : 'utc',
      mode: 'time',
      // requires `time` flot plugin
      font: {
        color: _constants.CHART_TEXT_COLOR
      }
    },
    yaxis: {
      color: _constants.CHART_LINE_COLOR,
      font: {
        color: _constants.CHART_TEXT_COLOR
      }
    },
    series: {
      points: {
        show: true,
        radius: 1
      },
      lines: {
        show: true,
        lineWidth: 2
      },
      shadowSize: 0
    },
    grid: {
      margin: 0,
      borderWidth: 1,
      borderColor: _constants.CHART_LINE_COLOR,
      hoverable: true
    },
    crosshair: {
      // requires `crosshair` flot plugin
      mode: 'x',
      color: '#c66',
      lineWidth: 2
    },
    selection: {
      // requires `selection` flot plugin
      mode: 'x',
      color: _constants.CHART_TEXT_COLOR
    }
  };
  return (0, _lodash.merge)(opts, axisOptions);
}