"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewTimeFields = void 0;
var _react = require("react");
var _ml = require("../../../../contexts/ml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataViewTimeFields = ({
  actions,
  state
}) => {
  const {
    setFormState
  } = actions;
  const {
    selectedDataView
  } = (0, _ml.useDataSource)();
  const [dataViewAvailableTimeFields, setDataViewAvailableTimeFields] = (0, _react.useState)([]);
  const onTimeFieldChanged = (0, _react.useCallback)(e => {
    const value = e.target.value;
    // If the value is an empty string, it's not a valid selection
    if (value === '') {
      return;
    }
    // Find the time field based on the selected value
    // this is to account for undefined when user chooses not to use a date field
    const timeField = dataViewAvailableTimeFields.find(col => col === value);
    setFormState({
      timeFieldName: timeField
    });
  }, [dataViewAvailableTimeFields, setFormState]);
  (0, _react.useEffect)(() => {
    // Default timeFieldName to the source data view's time field if it exists
    if (selectedDataView !== undefined) {
      setFormState({
        timeFieldName: selectedDataView.timeFieldName
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    // Get possible timefields for the results data view
    if (selectedDataView !== undefined) {
      const timefields = selectedDataView.fields.filter(f => f.type === 'date').map(f => f.name);
      setDataViewAvailableTimeFields(timefields);
    }
  }, [selectedDataView, setFormState]);
  return {
    dataViewAvailableTimeFields,
    onTimeFieldChanged
  };
};
exports.useDataViewTimeFields = useDataViewTimeFields;