"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _common_providers = require("../../../apps/common_providers");
var _host_metrics_table = require("./host_metrics_table");
var _use_host_metrics_table = require("./use_host_metrics_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HookedHostMetricsTable({
  timerange,
  filterClauseDsl,
  metricsClient
}) {
  const hostMetricsTableProps = (0, _use_host_metrics_table.useHostMetricsTable)({
    timerange,
    filterClauseDsl,
    metricsClient
  });
  return /*#__PURE__*/_react.default.createElement(_host_metrics_table.HostMetricsTable, hostMetricsTableProps);
}
function HostMetricsTableWithProviders({
  timerange,
  filterClauseDsl,
  sourceId,
  metricsClient,
  ...coreProvidersProps
}) {
  return /*#__PURE__*/_react.default.createElement(_common_providers.CoreProviders, coreProvidersProps, /*#__PURE__*/_react.default.createElement(HookedHostMetricsTable, {
    timerange: timerange,
    filterClauseDsl: filterClauseDsl,
    metricsClient: metricsClient
  }));
}

// Use default export for lazy loading.
// eslint-disable-next-line import/no-default-export
var _default = exports.default = HostMetricsTableWithProviders;
module.exports = exports.default;