"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _asset_details = require("../../../components/asset_details");
var _asset_details_tabs = require("../../../common/asset_details_config/asset_details_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetDetailPage = () => {
  const {
    params: {
      type: nodeType,
      node: nodeId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  return /*#__PURE__*/_react.default.createElement(_asset_details.AssetDetails, {
    assetId: nodeId,
    assetType: nodeType,
    tabs: (0, _asset_details_tabs.getAssetDetailsTabs)(nodeType),
    renderMode: {
      mode: 'page'
    }
  });
};
exports.AssetDetailPage = AssetDetailPage;