"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _log_analysis = require("../../../../../../common/log_analysis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasetsList = ({
  datasets
}) => /*#__PURE__*/_react.default.createElement("ul", null, datasets.map(dataset => {
  const datasetLabel = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset.name);
  return /*#__PURE__*/_react.default.createElement("li", {
    key: datasetLabel
  }, /*#__PURE__*/_react.default.createElement(DatasetLabel, null, datasetLabel));
}));

/*
 * These aim at aligning the list with the EuiHealth list in the neighboring
 * column.
 */
exports.DatasetsList = DatasetsList;
const DatasetLabel = _styled.default.div`
  display: inline-block;
  margin-bottom: 2.5px;
  margin-top: 1px;
`;