"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRegistryUrl = void 0;
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// from https://github.com/elastic/package-registry#docker (maybe from OpenAPI one day)
// Package storage V2 URL
const PACKAGE_STORAGE_REGISTRY_URL = 'https://epr.elastic.co';
const getRegistryUrl = () => {
  var _appContextService$ge;
  const customUrl = (_appContextService$ge = _.appContextService.getConfig()) === null || _appContextService$ge === void 0 ? void 0 : _appContextService$ge.registryUrl;
  if (customUrl) {
    return customUrl;
  }
  return PACKAGE_STORAGE_REGISTRY_URL;
};
exports.getRegistryUrl = getRegistryUrl;