"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedOptionsSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _services = require("../../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedOptionsSection = ({
  enabled,
  inputs
}) => {
  const {
    diskQueueEnabledInput,
    diskQueuePathInput,
    diskQueueMaxSizeInput,
    loadBalanceEnabledInput,
    diskQueueEncryptionEnabled,
    diskQueueCompressionEnabled,
    compressionLevelInput,
    memQueueEvents,
    queueFlushTimeout,
    maxBatchBytes
  } = inputs;
  const {
    showExperimentalShipperOptions
  } = _services.ExperimentalFeaturesService.get();
  return enabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedOutputOptions",
    arrowDisplay: "left",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.advancedOptionsToggleLabel",
      defaultMessage: "Advanced options"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: "Experimental",
      color: "subdued"
    })))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, maxBatchBytes.formRowProps, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescriptionLabel",
      defaultMessage: "Maximum Batch Size"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, maxBatchBytes.props, {
    placeholder: "Batching Bytes",
    min: 0
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescription",
    defaultMessage: "Data will be sent to the output when the agent has more events in the queue than this number."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, queueFlushTimeout.formRowProps, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutLabel",
      defaultMessage: "Flush Timeout"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, queueFlushTimeout.props, {
    placeholder: "Seconds",
    min: 0
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutDescription",
    defaultMessage: "Upon expiry the output queue is flushed and data is written to the output."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, memQueueEvents.formRowProps, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.memQueueEventsLabel",
      defaultMessage: "Memory Queue Size"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, memQueueEvents.props, {
    placeholder: "Events",
    min: 0
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.memQueueEventsSizeDescription",
    defaultMessage: "Maximum number of events that can be stored in the queue. Default is set to 4096. When this queue is full, new events are dropped."
  }))))), showExperimentalShipperOptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, diskQueueEnabledInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "editOutputFlyout.diskQueueSwitch"
  }, diskQueueEnabledInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.diskQueueSwitchLabel",
      defaultMessage: "Disk Queue"
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.diskQueueSwitchDescription",
    defaultMessage: "Once enabled, events will be queued on disk if, for some reason, agent is not able to send them."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, diskQueueEncryptionEnabled.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "editOutputFlyout.diskQueueEncryption"
  }, diskQueueEncryptionEnabled.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionLabel",
      defaultMessage: "Disk Queue Encryption"
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionDescription",
    defaultMessage: "Enable encryption of data written to the disk queue."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.diskQueuePathLabel",
      defaultMessage: "Disk Queue Path"
    })
  }, diskQueuePathInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "settingsOutputsFlyout.diskQueuePath"
  }, diskQueuePathInput.props, {
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.editOutputFlyout.diskQueuePathPlaceholder', {
      defaultMessage: 'path_data/diskqueue'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, diskQueueMaxSizeInput.formRowProps, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.diskQueueMaxSize",
      defaultMessage: "Maximum Disk Queue Size"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({}, diskQueueMaxSizeInput.props, {
    placeholder: "Bytes",
    min: 0
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.diskQueueMaxSizeDescription",
    defaultMessage: "Limits the disk queue size for spooling of data. When data in the queue exceeds this limit, new events will be dropped."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, loadBalanceEnabledInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "editOutputFlyout.loadBalancingSwitch"
  }, loadBalanceEnabledInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.loadBalancingSwitchLabel",
      defaultMessage: "Load Balancing"
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.loadBalancingDescription",
    defaultMessage: "Once enabled, the agents will balance the load across all the hosts defined for this output. This will increase the number of connections opened by the agent."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "editOutputFlyout.compressionSwitch"
  }, diskQueueCompressionEnabled.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.compressionSwitchLabel",
      defaultMessage: "Compression"
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
    "data-test-subj": "editOutputFlyout.compressionLevelSelect",
    id: "selectCompressionLevel",
    "aria-label": "Use aria labels when no actual label is in use"
  }, compressionLevelInput.props))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.compressionSwitchDescription",
    defaultMessage: "Level 1 compression is the fastest, Level 9 however would provide the most compression."
  })))))))) : null;
};
exports.AdvancedOptionsSection = AdvancedOptionsSection;