"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipRow = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TooltipRow = ({
  label,
  value
}) => {
  return label && value ? /*#__PURE__*/_react2.default.createElement("tr", null, /*#__PURE__*/_react2.default.createElement("td", {
    css: ({
      euiTheme
    }) => (0, _react.css)`
          font-weight: ${euiTheme.font.weight.medium};
        `
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: ({
      euiTheme
    }) => (0, _react.css)`
              max-width: calc(${euiTheme.size.xl} * 5);
              overflow-wrap: break-word;
            `
  }, label)), /*#__PURE__*/_react2.default.createElement("td", null, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            overflow-wrap: break-word;
          `
  }, value))) : null;
};
exports.TooltipRow = TooltipRow;