"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaErrorsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../react_router_helpers");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SchemaErrorsCallout = ({
  viewErrorsPath
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: "danger",
  iconType: "warning",
  title: _constants.SCHEMA_ERRORS_TITLE,
  "data-test-subj": "schemaErrorsCallout"
}, /*#__PURE__*/_react.default.createElement("p", null, _constants.SCHEMA_ERRORS_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
  to: viewErrorsPath,
  color: "danger",
  fill: true,
  size: "s",
  "data-test-subj": "viewErrorsButton"
}, _constants.SCHEMA_ERRORS_BUTTON));
exports.SchemaErrorsCallout = SchemaErrorsCallout;