"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COPY_TO_CLIPBOARD = exports.BaseCommentActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COPY_TO_CLIPBOARD = exports.COPY_TO_CLIPBOARD = _i18n.i18n.translate('xpack.elasticAssistantPlugin.assistant.commentActions.copyToClipboard', {
  defaultMessage: 'Copy to clipboard'
});
/**
 * Returns the content of the message compatible with a standard markdown renderer.
 *
 * Content references are removed as they can only be rendered by the assistant.
 */
function getSelfContainedContent(content) {
  return (0, _elasticAssistantCommon.removeContentReferences)(content).trim();
}
const BaseCommentActionsComponent = ({
  message,
  children
}) => {
  var _message$content;
  const content = (_message$content = message.content) !== null && _message$content !== void 0 ? _message$content : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "copy-to-clipboard-action"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: COPY_TO_CLIPBOARD
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: getSelfContainedContent(content)
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": COPY_TO_CLIPBOARD,
    color: "primary",
    iconType: "copyClipboard",
    onClick: copy
  })))));
};
const BaseCommentActions = exports.BaseCommentActions = /*#__PURE__*/_react.default.memo(BaseCommentActionsComponent);