"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportProgress = exports.IMPORT_STATUS = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let IMPORT_STATUS = exports.IMPORT_STATUS = /*#__PURE__*/function (IMPORT_STATUS) {
  IMPORT_STATUS["INCOMPLETE"] = "incomplete";
  IMPORT_STATUS["COMPLETE"] = "complete";
  IMPORT_STATUS["FAILED"] = "danger";
  return IMPORT_STATUS;
}({});
const ImportProgress = ({
  statuses
}) => {
  const {
    reading,
    readStatus,
    parseJSONStatus,
    indexCreatedStatus,
    ingestPipelineCreatedStatus,
    dataViewCreatedStatus,
    uploadProgress,
    uploadStatus,
    createDataView,
    createPipeline,
    initializeDeployment,
    initializeDeploymentStatus
  } = statuses;
  let statusInfo = null;
  let completedStep = 0;
  if (reading === true && readStatus === IMPORT_STATUS.INCOMPLETE && parseJSONStatus === IMPORT_STATUS.INCOMPLETE) {
    completedStep = 0;
  }
  if (readStatus === IMPORT_STATUS.COMPLETE && initializeDeployment === true && initializeDeploymentStatus === IMPORT_STATUS.INCOMPLETE) {
    completedStep = 1;
  }
  if (readStatus === IMPORT_STATUS.COMPLETE && (initializeDeployment === false || initializeDeploymentStatus === IMPORT_STATUS.COMPLETE) && indexCreatedStatus === IMPORT_STATUS.INCOMPLETE && ingestPipelineCreatedStatus === IMPORT_STATUS.INCOMPLETE) {
    completedStep = 2;
  }
  if (indexCreatedStatus === IMPORT_STATUS.COMPLETE) {
    completedStep = 3;
  }
  if (ingestPipelineCreatedStatus === IMPORT_STATUS.COMPLETE || createPipeline === false && indexCreatedStatus === IMPORT_STATUS.COMPLETE) {
    completedStep = 4;
  }
  if (uploadStatus === IMPORT_STATUS.COMPLETE) {
    completedStep = 5;
  }
  if (dataViewCreatedStatus === IMPORT_STATUS.COMPLETE) {
    completedStep = 6;
  }
  let processFileTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.processFileTitle', {
    defaultMessage: 'Process file'
  });
  let initializeDeploymentTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.initializeDeploymentTitle', {
    defaultMessage: 'Initialize model deployment'
  });
  let createIndexTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.createIndexTitle', {
    defaultMessage: 'Create index'
  });
  let createIngestPipelineTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.createIngestPipelineTitle', {
    defaultMessage: 'Create ingest pipeline'
  });
  let uploadingDataTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.uploadDataTitle', {
    defaultMessage: 'Upload data'
  });
  let createDataViewTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.createDataViewTitle', {
    defaultMessage: 'Create data view'
  });
  const creatingIndexStatus = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.importProgress.stepTwoCreatingIndexDescription",
    defaultMessage: "Creating index"
  }));
  const creatingIndexAndIngestPipelineStatus = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.importProgress.stepTwoCreatingIndexIngestPipelineDescription",
    defaultMessage: "Creating index and ingest pipeline"
  }));
  if (completedStep >= 0) {
    processFileTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.processingFileTitle', {
      defaultMessage: 'Processing file'
    });
    statusInfo = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importProgress.processingImportedFileDescription",
      defaultMessage: "Processing file for import"
    }));
  }
  if (initializeDeployment) {
    if (completedStep >= 1) {
      processFileTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.fileProcessedTitle', {
        defaultMessage: 'File processed'
      });
      initializeDeploymentTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.initializingDeploymentTitle', {
        defaultMessage: 'Initializing model deployment'
      });
      statusInfo = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importProgress.processingImportedFileDescription",
        defaultMessage: "Initializing model deployment"
      }));
    }
  }
  if (completedStep >= 2) {
    processFileTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.fileProcessedTitle', {
      defaultMessage: 'File processed'
    });
    initializeDeploymentTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.deploymentInitializedTitle', {
      defaultMessage: 'Model deployed'
    });
    createIndexTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.creatingIndexTitle', {
      defaultMessage: 'Creating index'
    });
    statusInfo = createPipeline === true ? creatingIndexAndIngestPipelineStatus : creatingIndexStatus;
  }
  if (completedStep >= 3) {
    createIndexTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.indexCreatedTitle', {
      defaultMessage: 'Index created'
    });
    createIngestPipelineTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.creatingIngestPipelineTitle', {
      defaultMessage: 'Creating ingest pipeline'
    });
    statusInfo = createPipeline === true ? creatingIndexAndIngestPipelineStatus : creatingIndexStatus;
  }
  if (completedStep >= 4) {
    createIngestPipelineTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.ingestPipelineCreatedTitle', {
      defaultMessage: 'Ingest pipeline created'
    });
    uploadingDataTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.uploadingDataTitle', {
      defaultMessage: 'Uploading data'
    });
    statusInfo = /*#__PURE__*/_react.default.createElement(UploadFunctionProgress, {
      progress: uploadProgress
    });
  }
  if (completedStep >= 5) {
    uploadingDataTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.dataUploadedTitle', {
      defaultMessage: 'Data uploaded'
    });
    if (createDataView === true) {
      createDataViewTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.creatingDataViewTitle', {
        defaultMessage: 'Creating data view'
      });
      statusInfo = /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importProgress.creatingDataViewDescription",
        defaultMessage: "Creating data view"
      }));
    } else {
      statusInfo = null;
    }
  }
  if (completedStep >= 6) {
    createDataViewTitle = _i18n.i18n.translate('xpack.dataVisualizer.file.importProgress.dataViewCreatedTitle', {
      defaultMessage: 'Data view created'
    });
    statusInfo = null;
  }
  const steps = [{
    title: processFileTitle,
    status: parseJSONStatus === IMPORT_STATUS.FAILED // if JSON parsing failed, fail the first step
    ? parseJSONStatus : readStatus === IMPORT_STATUS.COMPLETE && parseJSONStatus === IMPORT_STATUS.COMPLETE ? 'complete' : 'selected',
    onClick: () => {}
  }];
  if (initializeDeployment === true) {
    steps.push({
      title: initializeDeploymentTitle,
      status: initializeDeploymentStatus !== IMPORT_STATUS.INCOMPLETE // Show failure/completed states first
      ? initializeDeploymentStatus : completedStep === 1 // Then show selected/incomplete states
      ? 'selected' : 'incomplete',
      onClick: () => {}
    });
  }
  steps.push({
    title: createIndexTitle,
    status: indexCreatedStatus !== IMPORT_STATUS.INCOMPLETE // Show failure/completed states first
    ? indexCreatedStatus : completedStep === 2 // Then show selected/incomplete states
    ? 'selected' : 'incomplete',
    onClick: () => {}
  });
  if (createPipeline === true) {
    steps.push({
      title: createIngestPipelineTitle,
      status: ingestPipelineCreatedStatus !== IMPORT_STATUS.INCOMPLETE // Show failure/completed states first
      ? ingestPipelineCreatedStatus : completedStep === 3 // Then show selected/incomplete states
      ? 'selected' : 'incomplete',
      onClick: () => {}
    });
  }
  steps.push({
    title: uploadingDataTitle,
    status: uploadStatus !== IMPORT_STATUS.INCOMPLETE // Show failure/completed states first
    ? uploadStatus : completedStep === 4 // Then show selected/incomplete states
    ? 'selected' : 'incomplete',
    onClick: () => {}
  });
  if (createDataView === true) {
    steps.push({
      title: createDataViewTitle,
      status: dataViewCreatedStatus !== IMPORT_STATUS.INCOMPLETE // Show failure/completed states first
      ? dataViewCreatedStatus : completedStep === 5 // Then show selected/incomplete states
      ? 'selected' : 'incomplete',
      onClick: () => {}
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: steps,
    style: {
      backgroundColor: 'transparent'
    }
  }), statusInfo && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), statusInfo));
};
exports.ImportProgress = ImportProgress;
const UploadFunctionProgress = ({
  progress
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.importProgress.uploadingDataDescription",
    defaultMessage: "Uploading data"
  })), progress < 100 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: progress,
    max: 100,
    color: "primary",
    size: "s"
  })));
};