"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createQueryStateObservable = createQueryStateObservable;
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/kibana-utils-plugin/public");
var _query_state = require("../query_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createQueryStateObservable({
  timefilter,
  filterManager,
  queryString
}) {
  const state = (0, _public.createStateContainer)((0, _query_state.getQueryState)({
    timefilter,
    filterManager,
    queryString
  }));
  return new _rxjs.Observable(subscriber => {
    let currentChange = {};
    const subs = [queryString.getUpdates$().subscribe(() => {
      currentChange.query = true;
      state.set({
        ...state.get(),
        query: queryString.getQuery()
      });
    }), timefilter.timefilter.getTimeUpdate$().subscribe(() => {
      currentChange.time = true;
      state.set({
        ...state.get(),
        time: timefilter.timefilter.getTime()
      });
    }), timefilter.timefilter.getRefreshIntervalUpdate$().subscribe(() => {
      currentChange.refreshInterval = true;
      state.set({
        ...state.get(),
        refreshInterval: timefilter.timefilter.getRefreshInterval()
      });
    }), filterManager.getUpdates$().subscribe(() => {
      currentChange.filters = true;
      const {
        filters
      } = state.get();
      const globalOld = filters === null || filters === void 0 ? void 0 : filters.filter(f => (0, _esQuery.isFilterPinned)(f));
      const appOld = filters === null || filters === void 0 ? void 0 : filters.filter(f => !(0, _esQuery.isFilterPinned)(f));
      const globalNew = filterManager.getGlobalFilters();
      const appNew = filterManager.getAppFilters();
      if (!globalOld || !(0, _esQuery.compareFilters)(globalOld, globalNew, _esQuery.COMPARE_ALL_OPTIONS)) {
        currentChange.globalFilters = true;
      }
      if (!appOld || !(0, _esQuery.compareFilters)(appOld, appNew, _esQuery.COMPARE_ALL_OPTIONS)) {
        currentChange.appFilters = true;
      }
      state.set({
        ...state.get(),
        filters: filterManager.getFilters()
      });
    }), state.state$.pipe((0, _rxjs.map)(newState => ({
      state: newState,
      changes: currentChange
    })), (0, _rxjs.tap)(() => {
      currentChange = {};
    })).subscribe(subscriber)];
    return () => {
      subs.forEach(s => s.unsubscribe());
    };
  });
}