"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FocusedTraceWaterfallEmbeddable = FocusedTraceWaterfallEmbeddable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _focused_trace_waterfall = require("../../components/shared/focused_trace_waterfall");
var _use_fetcher = require("../../hooks/use_fetcher");
var _loading = require("./loading");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FocusedTraceWaterfallEmbeddable({
  rangeFrom,
  rangeTo,
  traceId,
  docId
}) {
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/traces/{traceId}/{docId}', {
      params: {
        path: {
          traceId,
          docId
        },
        query: {
          start: rangeFrom,
          end: rangeTo
        }
      }
    });
  }, [docId, rangeFrom, rangeTo, traceId]);
  if ((0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, null);
  }
  if (data === undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      "data-test-subj": "FocusedTraceWaterfallEmbeddableNoData",
      color: "danger",
      size: "s",
      title: _i18n.i18n.translate('xpack.apm.focusedTraceWaterfallEmbeddable.noDataCalloutLabel', {
        defaultMessage: 'Trace waterfall could not be loaded.'
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_focused_trace_waterfall.FocusedTraceWaterfall, {
    items: data
  });
}