"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableAlertsTablePlugin = void 0;
var _register_alerts_table_embeddable_factory = require("./factories/register_alerts_table_embeddable_factory");
var _register_add_alerts_table_action = require("./actions/register_add_alerts_table_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EmbeddableAlertsTablePlugin {
  setup(core, {
    embeddable
  }) {
    (0, _register_alerts_table_embeddable_factory.registerAlertsTableEmbeddableFactory)({
      embeddable,
      core
    });
    return {};
  }
  start(coreServices, {
    uiActions
  }) {
    (0, _register_add_alerts_table_action.registerAddAlertsTableAction)({
      coreServices,
      uiActions
    });
    return {};
  }
  stop() {}
}
exports.EmbeddableAlertsTablePlugin = EmbeddableAlertsTablePlugin;